use expectations, clear	

foreach var in ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 {
	tab `var' if `var'>100, miss
	* should answer (any value including .a "don't know" and .b "refusal")
	g S`var'=`var'!=.
	* type of answer
	g T`var'=1 if `var'==.a | `var'==.b
	replace T`var'=2 if `var'==0 | `var'==100
	replace T`var'=3 if `var'==50
	replace T`var'=4 if `var'==10 | `var'==20 | `var'==30 | `var'==40 | `var'==60 | `var'==70 | `var'==80 | `var'==90
	replace T`var'=5 if `var'==5 | `var'==15 | `var'==25 | `var'==35 | `var'==45 | `var'==55 | `var'==65 ///
		 | `var'==75 | `var'==85 | `var'==95
	replace T`var'=6 if (`var'>=1 & `var'<=4) | (`var'>=96 & `var'<=99)
	replace T`var'=7 if S`var'==1 & T`var'==.
	}

foreach var in ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 {
	tab T`var', g(DT`var')
	}

egen _S=rowtotal(Sex_sunny Sex_inherit Sex_inherit50K Sex_leave50K Sex_leaveany Sex_leave150K ///
	Sex_gov_red_pen Sex_gov_age_incr Sex_expectancy Sex_better Sex_worse Sex_gov_age_63), missing
egen S=total(_S), by(mergeid) missing

forvalues i=1(1)7 {
	egen _A`i'=rowtotal(DTex_sunny`i' DTex_inherit`i' DTex_inherit50K`i' DTex_leave50K`i' DTex_leaveany`i' ///
		DTex_leave150K`i' DTex_gov_red_pen`i' DTex_gov_age_incr`i' DTex_expectancy`i' DTex_better`i' DTex_worse`i' DTex_gov_age_63`i'), missing
	egen A`i'=total(_A`i'), by(mergeid) missing
} 

g T=1 if S==A1
replace T=2 if A2>=1 & A2!=.
replace T=3 if A3>=1 & A3!=.
replace T=4 if A4>=1 & A4!=.
replace T=5 if A5>=1 & A5!=.
replace T=6 if A6>=1 & A6!=.
replace T=7 if A7>=1 & A7!=.

* check
sort mergeid
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==1
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==2
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==3
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==4	
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==5
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==6
browse mergeid ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==7	
	
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==1
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==2
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==3
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==4	
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==5
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==6
codebook ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 if T==7	

foreach var in ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 {
	
	g R`var'L=max(0,`var'-50) if T==2
	g R`var'U=min(`var'+50,100) if T==2

	replace R`var'L=max(0,`var'-25) if T==3
	replace R`var'U=min(`var'+25,100) if T==3

	replace R`var'L=max(0,`var'-5) if T==4
	replace R`var'U=min(`var'+5,100) if T==4
	
	replace R`var'L=max(0,`var'-2.5) if T==5
	replace R`var'U=min(`var'+2.5,100) if T==5
	
	replace R`var'L=`var' if T==6 & (`var'<=5 | (`var'>=95 & `var'<=100))
	replace R`var'U=`var' if T==6 & (`var'<=5 | (`var'>=95 & `var'<=100))

	replace R`var'L=max(0,`var'-2.5) if T==6 & `var'>5 & `var'<95
	replace R`var'U=min(`var'+2.5,100) if T==6 & `var'>5 & `var'<95

	replace R`var'L=`var' if T==7
	replace R`var'U=`var' if T==7

	replace R`var'L=0 if `var'==.a | `var'==.b
	replace R`var'U=100 if `var'==.a | `var'==.b
	
	replace R`var'L=. if `var'==.
	replace R`var'U=. if `var'==.	
	
	ren `var' or_`var'
	}
	
foreach var in ex_sunny ex_inherit ex_inherit50K ex_leave50K ex_leaveany ///
	ex_leave150K ex_gov_red_pen ex_gov_age_incr ex_expectancy ex_better ex_worse ex_gov_age_63 {
		compare R`var'L R`var'U
		compare R`var'L R`var'U if T<=5 & or_`var'!=.a & or_`var'!=.b /*<0*/
		compare R`var'L R`var'U if T==6 & (or_`var'<=5 | (or_`var'>=95 & or_`var'<=100)) /*zero*/
		compare R`var'L R`var'U if T==6 & or_`var'>5 & or_`var'<95     /*5*/
		compare R`var'L R`var'U if T==7 & or_`var'!=.a & or_`var'!=.b  /*zero*/
}	
	
keep mergeid country wave T R*L R*U or_ex_gov_red_pen or_ex_gov_age_incr
save rounding, replace
